"""ImCoolbar: A Cool bar for Dear ImGui
Python bindings for https://github.com/aiekick/ImCoolBar
"""
# ruff: noqa: B008
import enum
from typing import Optional
from imgui_bundle.imgui import ImVec2, ImVec2Like, WindowFlags, WindowFlags_

ImCoolBarFlags = int
ImGuiWindowFlags = WindowFlags
ImGuiWindowFlags_None = WindowFlags_.none

# !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!  AUTOGENERATED CODE !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
# <litgen_stub> // Autogenerated code below! Do not edit!
####################    <generated_from:ImCoolbar.h>    ####################
#
#MIT License
#
#Copyright (c) 2023 Stephane Cuillerdier (aka Aiekick)
#
#Permission is hereby granted, free of charge, to any person obtaining a copy
#of this software and associated documentation files (the "Software"), to deal
#in the Software without restriction, including without limitation the rights
#to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
#copies of the Software, and to permit persons to whom the Software is
#furnished to do so, subject to the following conditions:
#
#The above copyright notice and this permission notice shall be included in all
#copies or substantial portions of the Software.
#
#THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
#IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
#FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
#AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
#LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
#OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
#SOFTWARE.
#



class ImCoolBarFlags_(enum.Enum):
    #
    none = enum.auto()       # (= 0)
    vertical = enum.auto()   # (= (1 << 0))
    horizontal = enum.auto() # (= (1 << 1))


class ImCoolBarConfig:
    anchor: ImVec2 = ImVec2(-1.0, -1.0)
    normal_size: float = 40.0
    hovered_size: float = 60.0
    anim_step: float = 0.15
    effect_strength: float = 0.5
    def __init__(
        self,
        v_anchor: Optional[ImVec2Like] = None,
        v_normal_size: float = 40.0,
        v_hovered_size: float = 60.0,
        v_anim_step: float = 0.15,
        v_effect_strength: float = 0.5
        ) -> None:
        """Python bindings defaults:
            If vAnchor is None, then its default value will be: ImVec2(-1.0, -1.0)

         //
        """
        pass
def begin_cool_bar(
    v_label: str,
    v_cb_flags: Optional[ImCoolBarFlags] = None,
    v_config: Optional[ImCoolBarConfig] = None,
    v_flags: Optional[ImGuiWindowFlags] = None
    ) -> bool:
    """Python bindings defaults:
        If any of the params below is None, then its default value below will be used:
            * vCBFlags: ImCoolBarFlags_.vertical
            * vConfig: initialized with default value
            * vFlags: WindowFlags_.none
    """
    pass
def end_cool_bar() -> None:
    pass
def cool_bar_item() -> bool:
    pass
def get_cool_bar_item_width() -> float:
    pass
def get_cool_bar_item_scale() -> float:
    pass


####################    </generated_from:ImCoolbar.h>    ####################

# </litgen_stub> // Autogenerated code end!
